package JavaPonies;
/*
 * This is the form that holds the Pony animations and handles clicks and drags
 */


import javax.swing.*;
//import javax.swing.plaf.SliderUI;

import java.awt.*;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;


import com.sun.jna.platform.WindowUtils;

@SuppressWarnings("serial")
public class Pony_Form extends JDialog implements ActionListener, MouseMotionListener, MouseListener, KeyListener {
	// Pony image control
	public JLabel Pony_Image = new JLabel();
	
	// Pony image reference
	public ImageIcon CurrentImage = null;
	
	// Pony name
	private String PonyName = "";
	
	// Control the pony with arrow keys? 
	public boolean ManualControl = false;
	
	// Arrow keys being pressed
	public boolean PonyUp = false;
	public boolean PonyDown = false;
	public boolean PonyLeft = false;
	public boolean PonyRight = false;
	
	// Shift key being pressed (walk faster!!)
	public boolean PonySpeed = false;
	
	// Direction
	public boolean PonyDirection = false;
	
	// Should the pony be sleeping?
	public boolean should_be_sleeping = false;
	
	// List of lines to speak
	private List<Speaking_Line> Lines_Random = new LinkedList<Speaking_Line>();
	private List<Speaking_Line> Lines_Specific = new LinkedList<Speaking_Line>();
	
	// Tooltip window references
	private JWindow tooltip = new JWindow();
	private JLabel tooltiplabel = new JLabel();
	
	// Tooltip timer
	private Timer tooltiptimer;
	
	// Click menu
	private JPopupMenu popupmenu = new JPopupMenu();
	private JMenuItem manualcontrolmenu = null;
	private JMenuItem singlesleep = null;
	private JMenuItem allsleep = null;	
	private JMenu addponymenu = null;
	
	private SuperObserver observer = null;
	private ImageIcon lastobservedimage = null;
		
	// Constructor
	public Pony_Form() {
		// Initialize tooltip window
		initializeTooltip();
		
		// Initialize form
		initializeForm();
	}

	// Initialize the window controls, transparency and handlers
	private void initializeForm() {
		// Remove borders and window buttons
		this.setUndecorated(true);
		
		// Add the Pony image control to the form and make it take all the space
		FlowLayout newLayout = new FlowLayout();
		newLayout.setVgap(0);
		newLayout.setHgap(0);
		this.getContentPane().setLayout(newLayout);		
		this.getContentPane().add(Pony_Image, BorderLayout.CENTER);
		this.setBackground(new Color(0,0,0,0.1f));
		Pony_Image.setOpaque(false);
		Pony_Image.setBackground(new Color(0,0,0,0.1f));
		
		// Attempt to make the window fully transparent
		try {
		   Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
		   Method mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, boolean.class);
		   mSetWindowOpacity.invoke(null, this, Boolean.valueOf(false));
		} catch (NoSuchMethodException ex) {
		   ex.printStackTrace();
		} catch (SecurityException ex) {
		   ex.printStackTrace();
		} catch (ClassNotFoundException ex) {
		   ex.printStackTrace();
		} catch (IllegalAccessException ex) {
		   ex.printStackTrace();
		} catch (IllegalArgumentException ex) {
		   ex.printStackTrace();
		} catch (InvocationTargetException ex) {
		   ex.printStackTrace();
		}
		
		// Add various event handlers
		Pony_Image.setFocusable(true);
		Pony_Image.addKeyListener(this);
				
		Pony_Image.setDoubleBuffered(Options.EnableDoubleBuffering);
		Pony_Image.addMouseListener(this);
		Pony_Image.addMouseMotionListener(this);
		
		// Initialize the click menu
		JMenuItem singlequit = new JMenuItem("Quit");
		singlequit.setActionCommand("ClosePony");
		singlequit.addActionListener(this);
		JMenuItem allquit = new JMenuItem("Quit ALL");
		allquit.setActionCommand("CloseAll");
		allquit.addActionListener(this);
		manualcontrolmenu = new JMenuItem("Take Control");
		manualcontrolmenu.setActionCommand("ManualControl");
		manualcontrolmenu.addActionListener(this);
		JMenuItem showoptions = new JMenuItem("Show Options");
		showoptions.setActionCommand("ShowOptions");
		showoptions.addActionListener(this);
		singlesleep = new JMenuItem("Sleep/Pause");
		singlesleep.setActionCommand("SleepPony");
		singlesleep.addActionListener(this);
		allsleep = new JMenuItem("Sleep/Pause All");
		allsleep.setActionCommand("SleepAll");
		allsleep.addActionListener(this);
		addponymenu = new JMenu("Add a pony->");
		
		popupmenu.add(singlequit);
		popupmenu.add(allquit);
		popupmenu.add(manualcontrolmenu);
		popupmenu.add(showoptions);
		popupmenu.add(singlesleep);
		popupmenu.add(allsleep);
		popupmenu.add(addponymenu);
		
		// Display the window (which should be transparent) and make it stay in front of every other window
		this.setSize(100, 100);
		this.setAlwaysOnTop(true);
		this.setVisible(false);
	}

	// Initialize the tooltip window (for pony speech)
	private void initializeTooltip() {
		// Boring stuff, it's a label inside a borderless window that gets hidden by a timer, nuff said
		FlowLayout newLayout = new FlowLayout();
		newLayout.setVgap(0);
		newLayout.setHgap(10);
		tooltip.getContentPane().setLayout(newLayout);
		tooltip.getContentPane().add(tooltiplabel, BorderLayout.CENTER);
		tooltip.getContentPane().setBackground(Color.WHITE);
		tooltip.setSize(200, 25);
		tooltip.setAlwaysOnTop(true);
		tooltip.setVisible(false);
		tooltiptimer = new Timer(3000, this);
		tooltiptimer.stop();
		//tooltiptimer.setActionCommand("HideTooltip");
	}
	
	// Set the Pony name
	public void SetPonyName(String name) {
		PonyName = name;
	}
	
	// Set the Pony speaking lines
	public void SetLines(List<Speaking_Line> speaking_lines) {
		for (Speaking_Line line : speaking_lines) {
			if (line.Skip)
				Lines_Specific.add(line);
			else
				Lines_Random.add(line);
		}
	}
	
	// Speak and say cute things!
	public void Pony_Speak(GraphicsDevice screen, Speaking_Line line, boolean override) {
		if (screen == null) return;
		
		Rectangle screenbounds = screen.getDefaultConfiguration().getBounds();
		
		// Verify if the user wants ponies to speak
		if (Options.Pony_Speak_Chance_Counter > 0 || override) {
			int selection = 0;
			String line_to_speak = "";
			
			if (Lines_Random.size() == 0) {
				if (line == null)
					return;
			} else {
				// Select the line to speak
				selection = WinMain.rand.nextInt(Lines_Random.size());
				line_to_speak = Lines_Random.get(selection).Text;
				if (Lines_Random.get(selection).SoundFile.length() > 0) Pony_PlaySound(Lines_Random.get(selection).SoundFile);
			}
			
			if (ManualControl) return;
			
			if (line != null) {
				line_to_speak = line.Text;
				if (line.SoundFile.length() > 0) Pony_PlaySound(line.SoundFile);
			}
			
			// Position and display the tooltip with the given line to speak
			tooltiplabel.setText(PonyName + ": \"" + line_to_speak + "\"");
			Point newLocation = new Point(this.getX() - 60, this.getY() - 10);
			newLocation.setLocation(Math.max(newLocation.x, screenbounds.getMinX()), Math.max(newLocation.y, screenbounds.getMinY()));
			tooltip.setLocation(newLocation);
			
			tooltip.setVisible(true);

			newLocation.setLocation(Math.min(newLocation.x, screenbounds.getMaxX() - tooltiplabel.getWidth() - 10), Math.min(newLocation.y, screenbounds.getMaxY() - tooltiplabel.getHeight()));
			tooltip.setLocation(newLocation);

			tooltip.setSize(tooltiplabel.getWidth() + 10, tooltiplabel.getHeight());
			tooltiptimer.start();
		}
	}
	
	// Play a wave file
	private void Pony_PlaySound(String filename) {
		if (Options.Sounds_Enabled) {
			try {
				// Open an input stream  to the audio file.
				InputStream in = new FileInputStream(filename);
				// Create an AudioStream object from the input stream.
				AudioStream as = new AudioStream(in);         
				// Use the static class member "player" from class AudioPlayer to play
				// clip.
				AudioPlayer.player.start(as);
			} catch(Exception ex) {
				// Debug output
				System.out.println("Could not play audio file: " + filename + "\n" + ex.getMessage());
			}
		}
	}
	
	public void setup_addpony_menu() {
		for (Pony pony : WinMain.currentInstance.Selectable_Ponies) {
			JMenuItem addpony = new JMenuItem(pony.Name.trim());
			addpony.setActionCommand("AddPony");
			addpony.addActionListener(this);
			addponymenu.add(addpony);
		}
	}

	// actionPerformed handler (timer and click menu)
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == tooltiptimer) { // Hide tooltip, timer says it's time to stop talking!
			tooltip.setVisible(false);
			tooltiptimer.stop();
		} else if (e.getActionCommand() == "ClosePony") { // Close this pony
			for (Pony pony : WinMain.currentInstance.Active_Ponies) {
				if (pony.Form == this) {
					WinMain.currentInstance.Active_Ponies.remove(pony);
					break;
				}
			}
			this.setVisible(false);
		} else if (e.getActionCommand() == "CloseAll") { // Close ALL ponies (application will quit automatically)
			while (!WinMain.currentInstance.Active_Ponies.isEmpty()) {
				WinMain.currentInstance.Active_Ponies.clear();
			}
		} else if (e.getActionCommand() == "ManualControl") { // Take or release control of this Pony
			ManualControl = !ManualControl;
			this.requestFocus();
			Pony_Image.requestFocus();
		} else if (e.getActionCommand() == "ShowOptions") { // Show the options form
			new Options(this);
		} else if (e.getActionCommand() == "SleepPony") { // Make this pony sleep or wake up
			should_be_sleeping = !should_be_sleeping;
		} else if (e.getActionCommand() == "SleepAll") { // Make all ponies sleep or wake up
			WinMain.currentInstance.sleep_all();
		} else if (e.getActionCommand() == "AddPony") { // Add a pony
			String pony_to_add = ((JMenuItem)e.getSource()).getText();
			
			for (Pony pony : WinMain.currentInstance.Selectable_Ponies) {
				if (pony.Name.trim().equalsIgnoreCase(pony_to_add)) {
					try {
						Pony new_pony = pony.Duplicate();
						WinMain.currentInstance.Active_Ponies.add(new_pony);
					} catch(Exception ex) { }
					break;
				}
			}
		}
	}

	// Display click menu on click (duh)
	public void mouseClicked(MouseEvent e) {
		// Change the text of ManualControl depending on its current value
		if (ManualControl)
			manualcontrolmenu.setText("Release Control");
		else
			manualcontrolmenu.setText("Take Control");
		
		if (should_be_sleeping)
			singlesleep.setText("Wake up/Resume");
		else
			singlesleep.setText("Sleep/Pause");
		
		if (WinMain.MoveTimer.isRunning())
			allsleep.setText("Sleep/Pause All");
		else
			allsleep.setText("Wake up/Resume All");
		
		popupmenu.show(this, e.getX() - 20, e.getY() - 20);
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}

	@Override
	public void mousePressed(MouseEvent e) {
	}

	@Override
	public void mouseReleased(MouseEvent e) {
	}

	// Drag the pony around like a big bully
	public void mouseDragged(MouseEvent e) {
		if (Options.Pony_Dragging_Enabled) {
			this.setLocation(new Point(e.getXOnScreen() - (this.getWidth() / 2), e.getYOnScreen() - (this.getHeight() / 2)));
		}
	}

	@Override
	public void mouseMoved(MouseEvent e) {		
	}

	// Make the Pony move against its will!
	public void keyPressed(KeyEvent e) {
		if (ManualControl) {
			switch (e.getKeyCode()) { // If an arrow key is pressed, set the flag to go in that direction!
				case KeyEvent.VK_DOWN:
					PonyDown = true;
					break;
				case KeyEvent.VK_UP:
					PonyUp = true;
					break;
				case KeyEvent.VK_RIGHT:
					PonyRight = true;
					break;
				case KeyEvent.VK_LEFT:
					PonyLeft = true;
					break;
			}
			
			// If the shift key is pressed, set the flag to make the Pony walk faster
			if (e.isShiftDown()) {
				PonySpeed = true;
			} else {
				PonySpeed = false;
			}
		}
	}

	// Same as above, but unset movement flags instead
	public void keyReleased(KeyEvent e) {
		if (ManualControl) {
			switch (e.getKeyCode()) { 
				case KeyEvent.VK_DOWN:
					PonyDown = false;
					break;
				case KeyEvent.VK_UP:
					PonyUp = false;
					break;
				case KeyEvent.VK_RIGHT:
					PonyRight = false;
					break;
				case KeyEvent.VK_LEFT:
					PonyLeft = false;
					break;
			}
			
			if (e.isShiftDown()) {
				PonySpeed = true;
			} else {
				PonySpeed = false;
			}
		}
	}

	@Override
	public void keyTyped(KeyEvent arg0) {
	}
	
	// Redraw the whole window to blank
	public void paint(Graphics g) {
		if (Options.EnableFullRedraw) {
	        Graphics2D g2d = (Graphics2D) g;
	        int w = this.getWidth();
	        int h = this.getHeight();
	        g2d.setComposite(AlphaComposite.Clear);
	        g2d.fillRect(0, 0, w, h);
	        g2d.setComposite(AlphaComposite.Src);
	        g2d.setPaint(g2d.getBackground());
	        g2d.fillRect(0, 0, w, h);
		}
		
		super.paint(g);
	}
	
	public void update(Graphics g) {
		if (Options.EnableFullRedraw) {
			paint(g);
		} else {
			super.update(g);
		}
	}
	
	// Observe an image (receive updates on frames)
	public void observeImage(ImageIcon img) {
		if (Options.EnableShapeWindow) {
			if (lastobservedimage != null)
				lastobservedimage.setImageObserver(null);
			if (observer != null)
				observer.StopObserving();
			
			observer = new SuperObserver(this);
			
			img.setImageObserver(observer);
			
			lastobservedimage = img;
		}
	}
	
	// On image frame draw
	public boolean imageUpdate(Image img,
            int infoflags,
            int x,
            int y,
            int width,
            int height) {
		
		// Do we shape windows (mostly for X11 fix)
		if (Options.EnableShapeWindow) {//(infoflags & ALLBITS) == ALLBITS || 
			if ((infoflags & FRAMEBITS) == FRAMEBITS || (infoflags & ALLBITS) == ALLBITS) {
				try {
					// If so, shape the window based on image transparency (limit to 30ms between shape drawing
					WindowUtils.setWindowMask(this, lastobservedimage);
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
		}
		
		return super.imageUpdate(img, infoflags, x, y, width, height);
	}
}
